<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';

$filter_where = '1=1';
if(is_caretaker()){
  $uid = current_user()['id'];
  $filter_where = "p.id IN (SELECT property_id FROM caretaker_properties WHERE user_id=" . (int)$uid . ")";
}
$stat_props = $pdo->query("SELECT COUNT(*) c FROM properties p WHERE $filter_where")->fetch()['c'] ?? 0;
$stat_tenants = $pdo->query("SELECT COUNT(*) c FROM tenants t LEFT JOIN properties p ON p.id=t.property_id WHERE $filter_where")->fetch()['c'] ?? 0;
$stat_due = $pdo->query("SELECT COALESCE(SUM(i.amount_due - i.amount_paid),0) due FROM invoices i LEFT JOIN tenants t ON t.id=i.tenant_id LEFT JOIN properties p ON p.id=t.property_id WHERE $filter_where")->fetch()['due'] ?? 0;
$stat_collected = $pdo->query("SELECT COALESCE(SUM(i.amount_paid),0) paid FROM invoices i LEFT JOIN tenants t ON t.id=i.tenant_id LEFT JOIN properties p ON p.id=t.property_id WHERE $filter_where")->fetch()['paid'] ?? 0;
?>
<h2>Dashboard</h2>
<div class="grid">
  <div class="card"><div class="muted">Properties</div><div style="font-size:28px;font-weight:800;"><?= e($stat_props) ?></div></div>
  <div class="card"><div class="muted">Tenants</div><div style="font-size:28px;font-weight:800;"><?= e($stat_tenants) ?></div></div>
  <div class="card"><div class="muted">Outstanding (KES)</div><div style="font-size:28px;font-weight:800;"><?= number_format($stat_due,2) ?></div></div>
  <div class="card"><div class="muted">Collected (KES)</div><div style="font-size:28px;font-weight:800;"><?= number_format($stat_collected,2) ?></div></div>
</div>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
