<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
ensure_csrf();

$tenants = $pdo->query("SELECT id,name FROM tenants ORDER BY name")->fetchAll();
$search = trim($_GET['q'] ?? ''); $status = $_GET['status'] ?? '';
$where='1=1'; $params=[];
if($search!==''){ $where.=" AND (t.name LIKE ? OR i.notes LIKE ?)"; $params=["%$search%","%$search%"]; }
if($status!==''){ $where.=" AND i.status=?"; $params[]=$status; }
if(is_caretaker()){ $uid=current_user()['id']; $where.=" AND t.property_id IN (SELECT property_id FROM caretaker_properties WHERE user_id=?)"; $params[]=$uid; }
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create'])){
    $amount = (float)$_POST['amount_due'];
    $water = (float)($_POST['water_fee'] ?? 0);
    $garbage = (float)($_POST['garbage_fee'] ?? 0);
    $extra = (float)($_POST['extra_fee'] ?? 0);
    $total = $amount + $water + $garbage + $extra;
    $pdo->prepare("INSERT INTO invoices (tenant_id, issue_date, due_date, amount_due, amount_paid, status, notes, water_fee, garbage_fee, extra_fee)
                   VALUES (?,?,?,?,0,'unpaid',?,?,?,?)")
        ->execute([(int)$_POST['tenant_id'], $_POST['issue_date'], $_POST['due_date'], $total, $_POST['notes'], $water, $garbage, $extra]);
  } elseif(isset($_POST['mark_paid'])){
    $pdo->prepare("UPDATE invoices SET amount_paid=amount_due, status='paid' WHERE id=?")->execute([(int)$_POST['id']]);
  } elseif(isset($_POST['delete']) && is_admin()){
    $pdo->prepare("DELETE FROM invoices WHERE id=?")->execute([(int)$_POST['id']]);
  }
}
$rows_st=$pdo->prepare("SELECT i.*, t.name AS tenant_name FROM invoices i LEFT JOIN tenants t ON t.id=i.tenant_id WHERE $where ORDER BY i.id DESC");
$rows_st->execute($params); $rows=$rows_st->fetchAll();
?>
<h2>Invoices</h2>
<form class="searchrow" method="get">
  <input name="q" value="<?= e($search) ?>" placeholder="Search tenant/notes">
  <select name="status"><option value="">All</option><option value="unpaid" <?= $status==='unpaid'?'selected':'' ?>>unpaid</option><option value="partial" <?= $status==='partial'?'selected':'' ?>>partial</option><option value="paid" <?= $status==='paid'?'selected':'' ?>>paid</option></select>
  <button class="btn"><?= filter_icon() ?> Filter</button>
  <a class="btn" href="export_invoices.php">Export CSV</a>
</form>
<form method="post" class="grid">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="card"><label>Tenant</label><select name="tenant_id"><?php foreach($tenants as $t): ?><option value="<?= e($t['id']) ?>"><?= e($t['name']) ?></option><?php endforeach; ?></select></div>
  <div class="card"><label>Issue Date</label><input name="issue_date" type="date" value="<?= date('Y-m-d') ?>"></div>
  <div class="card"><label>Due Date</label><input name="due_date" type="date" value="<?= date('Y-m-d', strtotime('+7 days')) ?>"></div>
  <div class="card"><label>Base Amount (KES)</label><input name="amount_due" type="number" step="0.01"></div>
  <div class="card"><label>Water</label><input name="water_fee" type="number" step="0.01" value="0"></div>
  <div class="card"><label>Garbage</label><input name="garbage_fee" type="number" step="0.01" value="0"></div>
  <div class="card"><label>Other</label><input name="extra_fee" type="number" step="0.01" value="0"></div>
  <div class="card"><label>Notes</label><input name="notes"></div>
  <div class="card"><label>&nbsp;</label><button class="btn primary" name="create">Create Invoice</button></div>
</form>
<table>
  <tr><th>#</th><th>Tenant</th><th>Issue</th><th>Due</th><th>Amount</th><th>Status</th><th>Actions</th></tr>
  <?php foreach($rows as $r): ?>
  <tr>
    <td><?= e($r['id']) ?></td>
    <td><?= e($r['tenant_name']) ?></td>
    <td><?= e($r['issue_date']) ?></td>
    <td><?= e($r['due_date']) ?></td>
    <td><?= number_format($r['amount_due'],2) ?></td>
    <td><span class="pill"><?= e($r['status']) ?></span></td>
    <td>
      <a class="btn" href="invoice_view.php?id=<?= e($r['id']) ?>">Print</a>
      <form method="post" style="display:inline-block">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>"><input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <button class="btn" name="mark_paid">Mark Paid</button>
      </form>
      <?php if(is_admin()): ?>
      <form method="post" style="display:inline-block" onsubmit="return confirm('Delete invoice?')">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>"><input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <button class="btn" name="delete">Delete</button>
      </form>
      <?php endif; ?>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
